"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_deregister(
      IN worker_id UUID
    )
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      UPDATE fhir.job_workers
      SET deleted_at = current_timestamp
      WHERE id = worker_id
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_garbage_collect()
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      UPDATE fhir.job_workers
      SET deleted_at = current_timestamp
      WHERE updated_at < current_timestamp - (setting_get('fhir.worker.assumeDroppedAfter') ->> 0)::interval
    $$
  `);
}
async function down(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_deregister(
      IN worker_id UUID
    )
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      DELETE FROM fhir.job_workers WHERE id = worker_id
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_garbage_collect()
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      DELETE FROM fhir.job_workers
      WHERE updated_at < current_timestamp - (setting_get('fhir.worker.assumeDroppedAfter') ->> 0)::interval
    $$
  `);
}

//# sourceMappingURL=1759454995510-SoftDeleteFhirJobWorkers.js.map