"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    const isFacility = Boolean((0, _selectFacilityIds.selectFacilityIds)(_config.default));
    // We still need changes_record_id index for the facility server
    // and changes_table_name_record_id index only benefits central server for pulling change logs.
    // Hence, skip the migration if this is a facility server
    if (isFacility) {
        return;
    }
    await query.sequelize.query(`
    DROP INDEX IF EXISTS logs.changes_record_id;

    CREATE INDEX changes_table_name_record_id
    ON logs.changes(table_name, record_id);
  `);
}
async function down(query) {
    const isFacility = Boolean((0, _selectFacilityIds.selectFacilityIds)(_config.default));
    if (isFacility) {
        return;
    }
    await query.sequelize.query(`
    DROP INDEX IF EXISTS logs.changes_table_name_record_id;

    CREATE INDEX changes_record_id 
    ON logs.changes 
    USING hash (record_id);
  `);
}

//# sourceMappingURL=1765504440717-AddAuditLogsRecordTypeRecordIdIndexes.js.map