import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class InvoicePatientPayment extends Model {
    id: string;
    methodId: string;
    chequeNumber?: string;
    invoicePaymentId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getListReferenceAssociations(models: Models): {
        model: typeof import("./ReferenceData").ReferenceData;
        as: string;
    }[];
}
//# sourceMappingURL=InvoicePatientPayment.d.ts.map