import { type DeviceScope } from '@tamanu/constants';
import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class Device extends Model {
    id: string;
    lastSeenAt: Date;
    registeredById: string;
    scopes: DeviceScope[];
    name?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getQuotaByUserId(userId: string): Promise<number>;
    markSeen(): Promise<void>;
    requiresQuota(): boolean;
    ensureHasScope(scope: DeviceScope): void;
}
//# sourceMappingURL=Device.d.ts.map