import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
export class DHIS2PushLog extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            reportId: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            status: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            message: {
                type: DataTypes.TEXT,
                allowNull: true
            },
            imported: {
                type: DataTypes.INTEGER,
                allowNull: true
            },
            updated: {
                type: DataTypes.INTEGER,
                allowNull: true
            },
            ignored: {
                type: DataTypes.INTEGER,
                allowNull: true
            },
            deleted: {
                type: DataTypes.INTEGER,
                allowNull: true
            },
            conflicts: {
                type: DataTypes.JSON,
                allowNull: true
            }
        }, {
            ...options,
            tableName: 'dhis2_pushes',
            syncDirection: SYNC_DIRECTIONS.DO_NOT_SYNC,
            schema: 'logs'
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReportDefinition, {
            foreignKey: 'reportId',
            as: 'report'
        });
    }
}

//# sourceMappingURL=DHIS2PushLog.js.map