"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    END: function() {
        return END;
    },
    MIGRATION_PREFIX: function() {
        return MIGRATION_PREFIX;
    },
    START: function() {
        return START;
    },
    STEP_PREFIX: function() {
        return STEP_PREFIX;
    },
    migrationFile: function() {
        return migrationFile;
    },
    needsMigration: function() {
        return needsMigration;
    },
    needsStep: function() {
        return needsStep;
    },
    onlyMigrations: function() {
        return onlyMigrations;
    },
    onlySteps: function() {
        return onlySteps;
    },
    stepFile: function() {
        return stepFile;
    }
});
const _nodepath = require("node:path");
const START = ':start:';
const END = ':end:';
const MIGRATION_PREFIX = 'migration/';
const STEP_PREFIX = 'upgrade/';
const needsStep = (step)=>{
    const re = RegExp("^(?<file>.+?)(\\/(?<index>\\d+))?$");
    const { file, index } = re.exec(step)?.groups || {};
    if (!file) throw new Error(`Invalid step name: ${step}`);
    if (!index) throw new Error('You must provide an index when depending on upgrade steps');
    return `upgrade/${(0, _nodepath.basename)(file, (0, _nodepath.extname)(file))}/${index}`;
};
const needsMigration = (mig)=>`migration/${(0, _nodepath.basename)(mig, (0, _nodepath.extname)(mig))}`;
const onlySteps = (needs)=>needs.filter((need)=>need.startsWith(STEP_PREFIX));
const onlyMigrations = (needs)=>needs.filter((need)=>need.startsWith(MIGRATION_PREFIX));
const stepFile = (str)=>str.split('/')[1] + '.js';
const migrationFile = (str)=>str.split('/')[1] + '.js';

//# sourceMappingURL=step.js.map