export class Entry {
    /**
     * Create a new argument entry with the given value
     *
     * @param {Value['value']} value
     * @returns {Entry}
     */
    static createArgument(value: Value['value']): Entry;
    /**
     * Create a new property entry for the given key and value
     *
     * @param {string} name
     * @param {Value['value']} value
     * @returns {Entry}
     */
    static createProperty(name: string, value: Value['value']): Entry;
    /**
     * @readonly
     */
    static readonly type: "entry";
    /**
     * @param {Value} value
     * @param {Identifier | null} name
     */
    constructor(value: Value, name: Identifier | null);
    /**
     * @readonly
     */
    readonly type: "entry";
    /**
     * The name of this entry if it's a property, or null if it's an argument
     *
     * @type {Identifier | null}
     */
    name: Identifier | null;
    /**
     * The value of this entry
     *
     * @type {Value}
     */
    value: Value;
    /**
     * Tag attached to this value, if any
     *
     * @type {Identifier | null}
     */
    tag: Identifier | null;
    /**
     * Leading whitespace
     *
     * @type {string=}
     */
    leading: string | undefined;
    /**
     * Trailing whitespace
     *
     * @type {string=}
     */
    trailing: string | undefined;
    /**
     * Create an identical copy of this entry
     *
     * @returns {Entry}
     */
    clone(): Entry;
    /**
     * Return the tag of this entry, if any
     *
     * @returns {string | null}
     */
    getTag(): string | null;
    /**
     * Set the tag of this entry to the given tag
     *
     * @param {string | null | undefined} tag
     */
    setTag(tag: string | null | undefined): void;
    /**
     * Return the name of this entry, if any
     *
     * @returns {string | null}
     */
    getName(): string | null;
    /**
     * Set the name of this entry to the given name
     *
     * @param {string | null | undefined} name
     */
    setName(name: string | null | undefined): void;
    /**
     * Return the value of this entry
     *
     * @returns {Value['value']}
     */
    getValue(): Value['value'];
    /**
     * Set the name of this entry to the given name
     *
     * @param {Value['value']} value
     */
    setValue(value: Value['value']): void;
    /**
     * Return whether this entry is an argument
     *
     * @returns {boolean}
     */
    isArgument(): boolean;
    /**
     * Return whether this entry is a named property
     *
     * @returns {boolean}
     */
    isProperty(): boolean;
}
import { Identifier } from "./identifier.js";
import { Value } from "./value.js";
