"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getImmunizations", {
    enumerable: true,
    get: function() {
        return getImmunizations;
    }
});
const _uuid = require("uuid");
const _constants = require("@tamanu/constants");
const _fhir = require("@tamanu/shared/utils/fhir");
const _utils = require("../utils");
const _administeredVaccine = require("../../../administeredVaccine");
const getImmunizations = async ({ patient, models, dataDictionariesIps })=>{
    const administeredVaccines = await models.AdministeredVaccine.findAll({
        where: {
            '$encounter.patient_id$': patient.id
        },
        include: [
            {
                model: models.ScheduledVaccine,
                as: 'scheduledVaccine',
                include: [
                    'vaccine'
                ]
            },
            {
                model: models.Encounter,
                as: 'encounter'
            }
        ]
    });
    const administeredVaccinesHeader = {
        resourceType: _constants.FHIR_RESOURCE_TYPES.IMMUNIZATION,
        patient: (0, _utils.getEntryResourceSubject)(patient)
    };
    if (!administeredVaccines?.length) {
        const immunizationCodingDisplay = 'No information about immunizations';
        return [
            {
                id: (0, _uuid.v4)(),
                ...administeredVaccinesHeader,
                vaccineCode: {
                    coding: [
                        {
                            system: dataDictionariesIps.absentUnknown,
                            code: 'no-immunization-info',
                            display: immunizationCodingDisplay
                        }
                    ]
                },
                text: {
                    status: 'generated',
                    div: `<div xmlns="http://www.w3.org/1999/xhtml">These are the Immunizations for ${patient.displayName} for ${immunizationCodingDisplay}. Please review the data for more detail.</div>`
                },
                occurrenceString: 'unknown',
                status: 'not-done'
            }
        ];
    }
    return administeredVaccines.map((administeredVaccine)=>({
            id: (0, _uuid.v4)(),
            ...administeredVaccinesHeader,
            vaccineCode: {
                coding: [
                    {
                        system: dataDictionariesIps.immunizationEncoding,
                        code: administeredVaccine.scheduledVaccine.vaccine.code,
                        display: administeredVaccine.scheduledVaccine.vaccine.name
                    }
                ]
            },
            text: {
                status: 'generated',
                div: `<div xmlns="http://www.w3.org/1999/xhtml">These are the Immunization details for ${patient.displayName} for ${administeredVaccine.scheduledVaccine.vaccine.name}. Please review the data for more detail.</div>`
            },
            status: (0, _administeredVaccine.administeredVaccineStatusToHL7Status)(administeredVaccine.status),
            ...administeredVaccine.date ? {
                occurrenceDateTime: (0, _fhir.formatFhirDate)(administeredVaccine.date)
            } : {
                occurrenceString: 'unknown'
            }
        }));
};

//# sourceMappingURL=immunization.js.map