"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getAllergies", {
    enumerable: true,
    get: function() {
        return getAllergies;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _allergyschema = require("@tamanu/shared/schemas/patientPortal/responses/allergy.schema");
const _schemaUtils = require("../../utils/schemaUtils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getAllergies = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const allergies = await models.PatientAllergy.findAll({
        where: {
            patientId: patient.id
        },
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_allergyschema.AllergySchema),
        include: [
            {
                model: models.ReferenceData,
                as: 'allergy',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_allergyschema.AllergySchema.shape.allergy)
            },
            {
                model: models.ReferenceData,
                as: 'reaction',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_allergyschema.AllergySchema.shape.reaction)
            }
        ]
    });
    res.send({
        data: allergies.map((allergy)=>_allergyschema.AllergySchema.parse(allergy.forResponse()))
    });
});

//# sourceMappingURL=allergies.js.map