"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "startFhirWorkerTasks", {
    enumerable: true,
    get: function() {
        return startFhirWorkerTasks;
    }
});
const _tasks = require("@tamanu/shared/tasks");
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const _allFromUpstream = require("./refresh/allFromUpstream");
const _entireResource = require("./refresh/entireResource");
const _fromUpstream = require("./refresh/fromUpstream");
const _resolver = require("./resolver");
async function startFhirWorkerTasks({ store, topics }) {
    const worker = new _tasks.FhirWorker(store, _logging.log);
    await worker.start();
    const setHandler = async (topic, handler)=>{
        if (!topics || topics.includes(topic)) {
            await worker.setHandler(topic, handler);
        }
    };
    await setHandler(_constants.JOB_TOPICS.FHIR.REFRESH.ALL_FROM_UPSTREAM, _allFromUpstream.allFromUpstream);
    await setHandler(_constants.JOB_TOPICS.FHIR.REFRESH.ENTIRE_RESOURCE, _entireResource.entireResource);
    await setHandler(_constants.JOB_TOPICS.FHIR.REFRESH.FROM_UPSTREAM, _fromUpstream.fromUpstream);
    await setHandler(_constants.JOB_TOPICS.FHIR.RESOLVER, _resolver.resolver);
    worker.processQueueNow();
    return worker;
}

//# sourceMappingURL=index.js.map