import { Model } from './Model';
import type { InitOptions } from '../types/model';
export declare class SyncQueuedDevice extends Model {
    id: string;
    facilityIds: string[];
    lastSeenTime?: Date;
    lastSyncedTick?: number;
    urgent?: boolean;
    static initModel(options: InitOptions): void;
    static getReadyDevicesWhereClause(): {
        lastSeenTime: {
            [x: symbol]: string | null;
        };
    };
    static getNextReadyDevice(): Promise<SyncQueuedDevice | null>;
    static checkSyncRequest(id: string, { facilityIds, urgent, lastSyncedTick, }: {
        facilityIds: string[];
        urgent: boolean;
        lastSyncedTick: number;
    }): Promise<SyncQueuedDevice | null>;
}
//# sourceMappingURL=SyncQueuedDevice.d.ts.map