"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const TABLE = {
    schema: 'fhir',
    tableName: 'job_workers'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        deleted_at: _sequelize.default.DATE,
        metadata: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false,
            defaultValue: {}
        }
    });
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_register(
      IN worker_info JSONB,
      OUT worker_id UUID
    )
      RETURNS NULL ON NULL INPUT
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      INSERT INTO fhir.job_workers (metadata) VALUES (worker_info)
      RETURNING id
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_heartbeat(
      IN worker_id UUID
    )
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      UPDATE fhir.job_workers SET updated_at = current_timestamp WHERE id = worker_id
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_deregister(
      IN worker_id UUID
    )
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      DELETE FROM fhir.job_workers WHERE id = worker_id
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_garbage_collect()
      RETURNS void
      LANGUAGE SQL
      VOLATILE PARALLEL UNSAFE
    AS $$
      DELETE FROM fhir.job_workers
      WHERE updated_at < current_timestamp - (setting_get('fhir.worker.assumeDroppedAfter') ->> 0)::interval
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.job_worker_is_alive(
      IN worker_id UUID,
      OUT alive BOOLEAN
    )
      LANGUAGE SQL
      STABLE PARALLEL SAFE
    AS $$
      SELECT coalesce((
        SELECT updated_at > current_timestamp - (setting_get('fhir.worker.assumeDroppedAfter') ->> 0)::interval
        FROM fhir.job_workers
        WHERE id = worker_id
      ), false)
    $$
  `);
}
async function down(query) {
    await query.sequelize.query('DROP FUNCTION IF EXISTS fhir.job_worker_is_alive');
    await query.sequelize.query('DROP FUNCTION IF EXISTS fhir.job_worker_garbage_collect');
    await query.sequelize.query('DROP FUNCTION IF EXISTS fhir.job_worker_deregister');
    await query.sequelize.query('DROP FUNCTION IF EXISTS fhir.job_worker_heartbeat');
    await query.sequelize.query('DROP FUNCTION IF EXISTS fhir.job_worker_register');
    await query.dropTable(TABLE);
}

//# sourceMappingURL=1673867394666-addJobWorkerTable.js.map