"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MultipleImagingRequestsPrintout", {
    enumerable: true,
    get: function() {
        return MultipleImagingRequestsPrintout;
    }
});
const _proptypes = /*#__PURE__*/ _interop_require_default(require("prop-types"));
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _patientAccessors = require("../patientAccessors");
const _BaseSigningSection = require("./BaseSigningSection");
const _getDisplayDate = require("./getDisplayDate");
const _Layout = require("./Layout");
const _notes = require("@tamanu/constants/notes");
const _LetterheadSection = require("./LetterheadSection");
const _DataItem = require("./printComponents/DataItem");
const _EncounterDetails = require("./printComponents/EncounterDetails");
const _HorizontalRule = require("./printComponents/HorizontalRule");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _PatientDetailsWithBarcode = require("./printComponents/PatientDetailsWithBarcode");
const _lodash = require("lodash");
const _DoubleHorizontalRule = require("./printComponents/DoubleHorizontalRule");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DATE_TIME_FORMAT = 'dd/MM/yyyy h:mma';
const labDetailsSectionStyles = _renderer.StyleSheet.create({
    barcodeLabelText: {
        marginTop: 9
    },
    divider: {
        borderBottom: '2px solid black',
        marginVertical: '10px'
    },
    detailsContainer: {
        marginBottom: 5
    },
    heading: {
        fontSize: 11,
        marginVertical: 3
    }
});
const generalStyles = _renderer.StyleSheet.create({
    container: {
        marginVertical: 6
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container,
        ...props
    });
const MultipleImagingRequestSigningSection = ()=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_BaseSigningSection.BaseSigningSection, null)));
};
const getImagingRequestType = (imagingTypes)=>({ imagingType })=>imagingTypes[imagingType]?.label || 'Unknown';
const getAreaNote = ({ areas, areaNote })=>{
    if (areas && areas.length > 0) {
        return areas.map((area)=>area.name).join(',');
    }
    if (areaNote) {
        // there's no sensible way to key this except by array index
        // eslint-disable-next-line react/no-array-index-key
        return areaNote;
    }
    return '';
};
const ImagingRequestDetailsView = ({ imagingRequests, getLocalisation })=>{
    const notesAccessor = ({ notes })=>{
        return notes?.filter((note)=>note.noteType === _notes.NOTE_TYPES.OTHER).map((note)=>note.content).join(', ');
    };
    const imagingTypes = getLocalisation('imagingTypes') || {};
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: labDetailsSectionStyles.heading
    }, "Imaging request details"), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, {
        width: "0.5px"
    }), imagingRequests.map((imagingRequest, index)=>{
        return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            key: imagingRequest.id,
            style: labDetailsSectionStyles.detailsContainer
        }, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Request ID",
            value: imagingRequest.displayId
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Priority",
            value: (0, _lodash.startCase)(imagingRequest.priority)
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Type",
            value: getImagingRequestType(imagingTypes)(imagingRequest)
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Area to be imaged",
            value: getAreaNote(imagingRequest)
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Notes",
            value: notesAccessor(imagingRequest)
        })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Requested date & time",
            value: (0, _getDisplayDate.getDisplayDate)(imagingRequest.requestedDate, DATE_TIME_FORMAT)
        }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: "Requested by",
            value: imagingRequest.requestedBy?.displayName
        })))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: {
                marginTop: 5
            }
        }, index < imagingRequests.length - 1 ? /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, {
            width: "0.5px"
        }) : /*#__PURE__*/ _react.default.createElement(_DoubleHorizontalRule.DoubleHorizontalRule, null)));
    }));
};
const MultipleImagingRequestsPrintoutComponent = /*#__PURE__*/ _react.default.memo(({ patient, imagingRequests, encounter, certificateData, getLocalisation, getSetting })=>{
    const { logo } = certificateData;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: "Imaging request",
        patientName: (0, _patientAccessors.getName)(patient),
        patientId: patient.displayId
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        certificateTitle: "Imaging Request"
    }), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithBarcode.PatientDetailsWithBarcode, {
        patient: patient,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_EncounterDetails.EncounterDetails, {
        encounter: encounter
    }))), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateContent, null, /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(ImagingRequestDetailsView, {
        imagingRequests: imagingRequests,
        getLocalisation: getLocalisation
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(MultipleImagingRequestSigningSection, null)))));
});
const MultipleImagingRequestsPrintout = (0, _languageContext.withLanguageContext)(MultipleImagingRequestsPrintoutComponent);
MultipleImagingRequestsPrintout.propTypes = {
    patient: _proptypes.default.object.isRequired,
    encounter: _proptypes.default.object.isRequired,
    imagingRequests: _proptypes.default.array.isRequired,
    certificateData: _proptypes.default.object.isRequired
};

//# sourceMappingURL=MultipleImagingRequestsPrintout.js.map