"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createSurveyResponse", {
    enumerable: true,
    get: function() {
        return createSurveyResponse;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _index = require("@tamanu/shared/services/logging/index");
const _createSurveyResponseschema = require("@tamanu/shared/schemas/patientPortal/requests/createSurveyResponse.schema");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _settings = require("@tamanu/settings");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const createSurveyResponse = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const body = _createSurveyResponseschema.CreateSurveyResponseRequestSchema.parse(req.body);
    const assignedSurvey = await models.PortalSurveyAssignment.findOne({
        where: {
            patientId: patient.id,
            status: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.OUTSTANDING,
            surveyId: body.surveyId
        }
    });
    if (!assignedSurvey) {
        _index.log.error('Patient attempted to submit response for invalid assigned survey', {
            patientId: patient.id,
            surveyId: body.surveyId
        });
        throw new _errors.NotFoundError('Survey was not assigned to the patient');
    }
    const { facilityId } = assignedSurvey;
    const settingsReader = new _settings.ReadSettings(models, facilityId);
    const getDefaultId = async (resource)=>models.SurveyResponseAnswer.getDefaultId(resource, settingsReader);
    const responseRecord = await req.store.sequelize.transaction(async ()=>{
        const { locationId, departmentId, ...payload } = body;
        const updatedBody = {
            patientId: patient.id,
            locationId: locationId || await getDefaultId('location'),
            departmentId: departmentId || await getDefaultId('department'),
            userId: _constants.SYSTEM_USER_UUID,
            facilityId,
            ...payload
        };
        const surveyResponse = await models.SurveyResponse.createWithAnswers(updatedBody);
        await assignedSurvey.update({
            surveyResponseId: surveyResponse.id,
            status: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.COMPLETED
        });
        return surveyResponse;
    });
    return res.send(responseRecord);
});

//# sourceMappingURL=surveyResponse.js.map