"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "CreateSurveyResponseRequestSchema", {
    enumerable: true,
    get: function() {
        return CreateSurveyResponseRequestSchema;
    }
});
const _zod = require("zod");
const _types = require("../../types");
const CreateSurveyResponseRequestSchema = _zod.z.object({
    surveyId: _types.foreignKey,
    patientId: _types.foreignKey,
    answers: _zod.z.record(_zod.z.string(), _zod.z.unknown()),
    facilityId: _types.foreignKey.optional(),
    locationId: _types.foreignKey.optional(),
    departmentId: _types.foreignKey.optional(),
    startTime: _zod.z.string().nullish(),
    endTime: _zod.z.string().nullish()
});

//# sourceMappingURL=createSurveyResponse.schema.js.map