"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SurveyScreenComponent", {
    enumerable: true,
    get: function() {
        return SurveyScreenComponent;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _safeJsonParse = require("@tamanu/utils/safeJsonParse");
const _Model = require("./Model");
let SurveyScreenComponent = class SurveyScreenComponent extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            screenIndex: _sequelize.DataTypes.INTEGER,
            componentIndex: _sequelize.DataTypes.INTEGER,
            text: _sequelize.DataTypes.STRING,
            visibilityCriteria: _sequelize.DataTypes.STRING,
            validationCriteria: _sequelize.DataTypes.TEXT,
            detail: _sequelize.DataTypes.STRING,
            config: _sequelize.DataTypes.STRING,
            options: _sequelize.DataTypes.TEXT,
            calculation: _sequelize.DataTypes.STRING,
            visibilityStatus: _sequelize.DataTypes.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static getListReferenceAssociations(includeAllVitals) {
        return {
            model: this.sequelize.models.ProgramDataElement,
            as: 'dataElement',
            paranoid: !includeAllVitals
        };
    }
    static initRelations(models) {
        this.belongsTo(models.Survey, {
            foreignKey: 'surveyId'
        });
        this.belongsTo(models.ProgramDataElement, {
            foreignKey: 'dataElementId',
            as: 'dataElement'
        });
    }
    static async getComponentsForSurveys(surveyIds, options = {}) {
        const { includeAllVitals } = options;
        const where = {
            surveyId: {
                [_sequelize.Op.in]: surveyIds
            }
        };
        const components = await this.findAll({
            where,
            include: this.getListReferenceAssociations(includeAllVitals),
            order: [
                [
                    'screen_index',
                    'ASC'
                ],
                [
                    'component_index',
                    'ASC'
                ]
            ],
            paranoid: !includeAllVitals
        });
        return components.map((c)=>c.forResponse());
    }
    static getComponentsForSurvey(surveyId, options = {}) {
        return this.getComponentsForSurveys([
            surveyId
        ], options);
    }
    forResponse() {
        const { options, ...values } = this.dataValues;
        return {
            ...values,
            options: (0, _safeJsonParse.safeJsonParse)(options)
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=SurveyScreenComponent.js.map