"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "locationAssignments", {
    enumerable: true,
    get: function() {
        return locationAssignments;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const locationAssignments = _express.default.Router();
locationAssignments.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkListOrReadPermission('LocationAssignment');
    const { models: { LocationAssignment, User, Location }, query: { facilityId, locationId, clinicianId, after, before, rowsPerPage = 10, page = 0, all = false, order = 'ASC', orderBy = 'date' } } = req;
    const whereClause = {};
    if (facilityId) {
        whereClause['$location.facility_id$'] = facilityId;
    }
    if (locationId) {
        const locationIds = Array.isArray(locationId) ? locationId : [
            locationId
        ];
        whereClause.locationId = {
            [_sequelize.Op.in]: locationIds
        };
    }
    if (clinicianId) {
        const clinicianIds = Array.isArray(clinicianId) ? clinicianId : [
            clinicianId
        ];
        whereClause.userId = {
            [_sequelize.Op.in]: clinicianIds
        };
    }
    if (after) {
        whereClause.date = {
            ...whereClause.date,
            [_sequelize.Op.gte]: after
        };
    }
    if (before) {
        whereClause.date = {
            ...whereClause.date,
            [_sequelize.Op.lte]: before
        };
    }
    const includeOptions = [
        {
            model: User,
            as: 'user',
            attributes: [
                'id',
                'displayName',
                'email'
            ]
        },
        {
            model: Location,
            as: 'location',
            attributes: [
                'id',
                'name',
                'facilityId'
            ]
        }
    ];
    const { rows, count } = await LocationAssignment.findAndCountAll({
        where: whereClause,
        include: includeOptions,
        limit: all ? undefined : rowsPerPage,
        offset: all ? undefined : page * rowsPerPage,
        order: [
            [
                orderBy,
                order
            ]
        ]
    });
    res.send({
        count,
        data: rows
    });
}));

//# sourceMappingURL=locationAssignments.js.map