"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "userPreferencesRouter", {
    enumerable: true,
    get: function() {
        return userPreferencesRouter;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const userPreferencesRouter = _express.default.Router();
userPreferencesRouter.get('/userPreferences', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store: { models: { UserPreference } }, user: currentUser } = req;
    req.checkPermission('read', currentUser);
    const userPreferences = await UserPreference.getAllPreferences(currentUser.id, '');
    res.send(userPreferences || {});
}));
userPreferencesRouter.post('/userPreferences', (0, _expressasynchandler.default)(async (req, res)=>{
    const { store: { models: { UserPreference } }, user: currentUser, body: { facilityId = null, key, value } } = req;
    req.checkPermission('write', currentUser);
    const [userPreferences] = await UserPreference.upsert({
        key,
        value,
        userId: currentUser.id,
        facilityId,
        deletedAt: null
    });
    res.send(userPreferences);
}));

//# sourceMappingURL=userPreferences.js.map