"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getUpcomingAppointments", {
    enumerable: true,
    get: function() {
        return getUpcomingAppointments;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _schemaUtils = require("../../utils/schemaUtils");
const _appointmentschema = require("@tamanu/shared/schemas/patientPortal/responses/appointment.schema");
const _locationGroupschema = require("@tamanu/shared/schemas/patientPortal/responses/locationGroup.schema");
const _facilityschema = require("@tamanu/shared/schemas/patientPortal/responses/facility.schema");
const _dateTime = require("@tamanu/utils/dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const APPOINTMENT_ATTRIBUTES = {
    appointment: (0, _schemaUtils.getAttributesFromSchema)(_appointmentschema.AppointmentSchema),
    appointmentType: (0, _schemaUtils.getAttributesFromSchema)(_appointmentschema.AppointmentSchema.shape.appointmentType),
    facility: (0, _schemaUtils.getAttributesFromSchema)(_facilityschema.FacilitySchema),
    locationGroup: (0, _schemaUtils.getAttributesFromSchema)(_locationGroupschema.LocationGroupSchema),
    clinician: (0, _schemaUtils.getAttributesFromSchema)(_appointmentschema.AppointmentSchema.shape.clinician)
};
const createAppointmentIncludes = (models)=>[
        {
            model: models.ReferenceData,
            as: 'appointmentType',
            attributes: APPOINTMENT_ATTRIBUTES.appointmentType
        },
        {
            model: models.LocationGroup,
            as: 'locationGroup',
            attributes: APPOINTMENT_ATTRIBUTES.locationGroup,
            include: [
                {
                    model: models.Facility,
                    as: 'facility',
                    attributes: APPOINTMENT_ATTRIBUTES.facility
                }
            ]
        },
        {
            model: models.User,
            as: 'clinician',
            attributes: APPOINTMENT_ATTRIBUTES.clinician
        }
    ];
const getUpcomingAppointments = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const appointmentIncludes = createAppointmentIncludes(models);
    const today = new Date();
    today.setHours(0, 0, 0, 0);
    const appointments = await models.Appointment.findAll({
        where: {
            patientId: patient.id,
            locationGroupId: {
                [_sequelize.Op.not]: null
            },
            startTime: {
                [_sequelize.Op.gte]: (0, _dateTime.toDateTimeString)(today)
            }
        },
        attributes: APPOINTMENT_ATTRIBUTES.appointment,
        include: appointmentIncludes,
        order: [
            [
                'startTime',
                'ASC'
            ]
        ]
    });
    res.send(appointments.map((appointment)=>_appointmentschema.AppointmentSchema.parse(appointment.forResponse())));
});

//# sourceMappingURL=appointments.js.map