"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getPatient", {
    enumerable: true,
    get: function() {
        return getPatient;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _patientPortal = require("@tamanu/shared/schemas/patientPortal");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getPatient = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const village = await patient.getVillage();
    await req.audit.access({
        recordId: patient.id,
        model: req.models.Patient
    });
    res.send(_patientPortal.PatientWithAdditionalDataSchema.parse({
        ...patient.forResponse(),
        village: village?.forResponse()
    }));
});

//# sourceMappingURL=patient.js.map