"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('appointments', 'additional_clinician_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        }
    });
    await query.addColumn('appointments', 'link_encounter_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'encounters',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('appointments', 'additional_clinician_id');
    await query.removeColumn('appointments', 'link_encounter_id');
}

//# sourceMappingURL=1757319785725-addAdditionalClinicianIdAndLinkEncounterToAppointments.js.map