import { type BelongsToGetAssociationMixin } from 'sequelize';
import type { ReadSettings } from '@tamanu/settings';
import { Model } from './Model';
import { AppointmentSchedule, type AppointmentScheduleCreateData } from './AppointmentSchedule';
import { type InitOptions, type Models } from '../types/model';
interface CreateWithScheduleParams {
    appointmentData: AppointmentCreateData;
    settings: ReadSettings;
    scheduleData: AppointmentScheduleCreateData;
}
export type AppointmentCreateData = Omit<Appointment, 'id' | 'createdAt' | 'deletedAt'>;
export declare class Appointment extends Model {
    id: string;
    startTime: string;
    endTime?: string;
    status: string;
    typeLegacy?: string;
    isHighPriority: boolean;
    patientId?: string;
    clinicianId?: string;
    additionalClinicianId?: string;
    locationGroupId?: string;
    locationId?: string;
    bookingTypeId?: string;
    appointmentTypeId?: string;
    encounterId?: string;
    linkEncounterId?: string;
    scheduleId?: string;
    getSchedule: BelongsToGetAssociationMixin<AppointmentSchedule>;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getListReferenceAssociations(): (string | {
        association: string;
        include: string[];
        as?: undefined;
        separate?: undefined;
    } | {
        association: string;
        as: string;
        include: {
            association: string;
            include: string[];
        }[];
        separate?: undefined;
    } | {
        association: string;
        include: string[];
        separate: boolean;
        as?: undefined;
    })[];
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static createWithSchedule({ settings, appointmentData, scheduleData, }: CreateWithScheduleParams): Promise<{
        firstAppointment: Appointment | undefined;
        schedule: AppointmentSchedule;
    }>;
    /** Convert the appointment to a data object that can be used to create a new appointment. */
    toCreateData(): AppointmentCreateData;
    setProcedureTypes(procedureTypeIds: string[]): Promise<void>;
}
export {};
//# sourceMappingURL=Appointment.d.ts.map