"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    migrateImagingRequests: function() {
        return migrateImagingRequests;
    },
    migrateImagingRequestsToLocationGroupsCommand: function() {
        return migrateImagingRequestsToLocationGroupsCommand;
    }
});
const _commander = require("commander");
const _sequelize = require("sequelize");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("../database");
async function migrateImagingRequests() {
    _logging.log.info('Migrating imaging requests...');
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const { ImagingRequest } = store.models;
    try {
        let migrated = 0;
        const imagingRequests = await ImagingRequest.findAll({
            include: 'location',
            where: {
                locationGroupId: {
                    [_sequelize.Op.is]: null
                },
                locationId: {
                    [_sequelize.Op.not]: null
                }
            }
        });
        await Promise.all(imagingRequests.map(async (record)=>{
            const { location } = record;
            const { locationGroupId } = location;
            if (locationGroupId) {
                await record.update({
                    locationGroupId
                });
                migrated++;
            } else {
                // Skip if there is no location group
                _logging.log.warn(`The following location has no related location group: ${location.name}`);
            }
            return location;
        }));
        _logging.log.info(`Successfully migrated ${migrated} records`);
        process.exit(0);
    } catch (error) {
        _logging.log.info(`Command failed: ${error.stack}\n`);
        process.exit(1);
    }
}
const migrateImagingRequestsToLocationGroupsCommand = new _commander.Command('migrateImagingRequestsToLocationGroups').description('Migrates imaging requests from locations to location groups').action(migrateImagingRequests);

//# sourceMappingURL=migrateImagingRequestsToLocationGroups.js.map