import { z } from 'zod';
export declare const ProgramDataElementSchema: z.ZodObject<{
    id: z.ZodString;
    code: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    name: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    indicator: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    defaultText: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    defaultOptions: z.ZodNullable<z.ZodOptional<z.ZodUnknown>>;
    visualisationConfig: z.ZodNullable<z.ZodOptional<z.ZodUnknown>>;
    type: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, z.core.$strip>;
export declare const SurveyScreenComponentSchema: z.ZodObject<{
    id: z.ZodString;
    screenIndex: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
    componentIndex: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
    text: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    visibilityCriteria: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    validationCriteria: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    detail: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    config: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    options: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    calculation: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    visibilityStatus: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    dataElement: z.ZodNullable<z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        code: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        name: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        indicator: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        defaultText: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        defaultOptions: z.ZodNullable<z.ZodOptional<z.ZodUnknown>>;
        visualisationConfig: z.ZodNullable<z.ZodOptional<z.ZodUnknown>>;
        type: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    }, z.core.$strip>>>;
    dataElementId: z.ZodNullable<z.ZodOptional<z.ZodString>>;
}, z.core.$strip>;
export declare const SurveySchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    code: z.ZodString;
    surveyType: z.ZodEnum<{
        PROGRAMS: string;
        REFERRAL: string;
        OBSOLETE: string;
        VITALS: string;
        SIMPLE_CHART: string;
        COMPLEX_CHART: string;
        COMPLEX_CHART_CORE: string;
    }>;
}, z.core.$strip>;
export declare const SurveyWithComponentsSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    code: z.ZodString;
    surveyType: z.ZodEnum<{
        PROGRAMS: string;
        REFERRAL: string;
        OBSOLETE: string;
        VITALS: string;
        SIMPLE_CHART: string;
        COMPLEX_CHART: string;
        COMPLEX_CHART_CORE: string;
    }>;
    components: z.ZodNullable<z.ZodOptional<z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        screenIndex: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
        componentIndex: z.ZodNullable<z.ZodOptional<z.ZodNumber>>;
        text: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        visibilityCriteria: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        validationCriteria: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        detail: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        config: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        options: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        calculation: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        visibilityStatus: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        dataElement: z.ZodNullable<z.ZodOptional<z.ZodObject<{
            id: z.ZodString;
            code: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            name: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            indicator: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            defaultText: z.ZodNullable<z.ZodOptional<z.ZodString>>;
            defaultOptions: z.ZodNullable<z.ZodOptional<z.ZodUnknown>>;
            visualisationConfig: z.ZodNullable<z.ZodOptional<z.ZodUnknown>>;
            type: z.ZodNullable<z.ZodOptional<z.ZodString>>;
        }, z.core.$strip>>>;
        dataElementId: z.ZodNullable<z.ZodOptional<z.ZodString>>;
    }, z.core.$strip>>>>;
}, z.core.$strip>;
export type Survey = z.infer<typeof SurveySchema>;
export type SurveyWithComponents = z.infer<typeof SurveyWithComponentsSchema>;
export type ProgramDataElement = z.infer<typeof ProgramDataElementSchema>;
export type SurveyScreenComponent = z.infer<typeof SurveyScreenComponentSchema>;
//# sourceMappingURL=survey.schema.d.ts.map