"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MedicationDiscontinuer", {
    enumerable: true,
    get: function() {
        return MedicationDiscontinuer;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
const _sequelize = require("sequelize");
const _dateTime = require("@tamanu/utils/dateTime");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MedicationDiscontinuer = class MedicationDiscontinuer extends _tasks.ScheduledTask {
    getName() {
        return 'MedicationDiscontinuer';
    }
    async run() {
        await this.discontinueMedications();
    }
    async discontinueMedications() {
        const { Prescription } = this.models;
        const currentDateTime = (0, _dateTime.getCurrentDateTimeString)();
        await Prescription.update({
            discontinued: true,
            discontinuedDate: _sequelize.Sequelize.literal('end_date'),
            discontinuingClinicianId: _constants.SYSTEM_USER_UUID,
            discontinuingReason: 'Prescription end date and time reached'
        }, {
            where: {
                endDate: {
                    [_sequelize.Op.and]: [
                        {
                            [_sequelize.Op.lte]: currentDateTime
                        },
                        {
                            [_sequelize.Op.not]: null
                        }
                    ]
                },
                discontinued: {
                    [_sequelize.Op.not]: true
                }
            }
        });
    }
    /**
   *
   * @param {import('../ApplicationContext').ApplicationContext} context
   */ constructor(context){
        const { schedule, jitterTime, enabled } = _config.default.schedules.medicationDiscontinuer;
        super(schedule, _logging.log, jitterTime, enabled);
        this.models = context.store.models;
    }
};

//# sourceMappingURL=MedicationDiscontinuer.js.map