"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "removeSensitiveAnswers", {
    enumerable: true,
    get: function() {
        return removeSensitiveAnswers;
    }
});
const filterFromSurveyResponseAnswer = (records, responseIds)=>{
    return records.filter((record)=>!responseIds.includes(record.data.responseId));
};
const filterFromEncounter = (records, responseIds)=>{
    return records.map((record)=>({
            ...record,
            data: {
                ...record.data,
                // Only overwrite record.data.surveyResponses
                surveyResponses: record.data.surveyResponses.map((response)=>{
                    // Response should not contain answers
                    if (responseIds.includes(response.data.id)) {
                        // Overwrite only response.data.answers
                        return {
                            ...response,
                            data: {
                                ...response.data,
                                answers: []
                            }
                        };
                    }
                    // Don't filter response
                    return response;
                })
            }
        }));
};
const removeSensitiveAnswers = async (channel, models, records)=>{
    // Find all SurveyResponse from sensitive surveys
    const sensitiveResponses = await models.SurveyResponse.findAll({
        attributes: [
            'id'
        ],
        include: [
            {
                association: 'survey',
                attributes: [
                    'id'
                ],
                where: {
                    isSensitive: true
                }
            }
        ]
    });
    // Get array of SurveyResponse IDs
    const responseIds = sensitiveResponses.map((response)=>response.id);
    // Check which of the two channels is being accessed
    if (channel === 'surveyResponseAnswer') {
        return filterFromSurveyResponseAnswer(records, responseIds);
    }
    return filterFromEncounter(records, responseIds);
};

//# sourceMappingURL=removeSensitiveAnswers.js.map