"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "convertDatabaseError", {
    enumerable: true,
    get: function() {
        return convertDatabaseError;
    }
});
const _errors = require("@tamanu/errors");
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
function convertDatabaseError(error) {
    if (error instanceof _sequelize.ValidationError) {
        return new _errors.DatabaseValidationError(error.message).withCause(error).withExtraData({
            validations: error.errors.map((err)=>err.validatorName)
        });
    }
    if (error instanceof _sequelize.ExclusionConstraintError) {
        return new _errors.DatabaseConstraintError(error.message).withCause(error).withExtraData({
            constraint: error.constraint
        });
    }
    if (error instanceof _sequelize.UnknownConstraintError) {
        return new _errors.DatabaseConstraintError(error.message).withCause(error).withExtraData({
            constraint: error.constraint
        });
    }
    if (error instanceof _sequelize.ForeignKeyConstraintError) {
        return new _errors.DatabaseRelationError(error.message).withCause(error).withExtraData({
            relation: error.index
        });
    }
    if (error instanceof _sequelize.UniqueConstraintError) {
        return new _errors.DatabaseDuplicateError(error.message).withCause(error);
    }
    return new _errors.DatabaseError(error.message).withCause(error);
}

//# sourceMappingURL=convertDatabaseError.js.map