"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ALL_SURVEY_IDS: function() {
        return ALL_SURVEY_IDS;
    },
    BREAST_CANCER_FORM_SURVEY_ID: function() {
        return BREAST_CANCER_FORM_SURVEY_ID;
    },
    BREAST_CANCER_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS: function() {
        return BREAST_CANCER_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS;
    },
    BREAST_CANCER_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS: function() {
        return BREAST_CANCER_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS;
    },
    BREAST_CANCER_SURVEY_GROUP_KEY: function() {
        return BREAST_CANCER_SURVEY_GROUP_KEY;
    },
    BREAST_CANCER_SURVEY_IDS: function() {
        return BREAST_CANCER_SURVEY_IDS;
    },
    CERVICAL_CANCER_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS: function() {
        return CERVICAL_CANCER_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS;
    },
    CERVICAL_CANCER_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS: function() {
        return CERVICAL_CANCER_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS;
    },
    CERVICAL_CANCER_SURVEY_GROUP_KEY: function() {
        return CERVICAL_CANCER_SURVEY_GROUP_KEY;
    },
    CERVICAL_CANCER_SURVEY_IDS: function() {
        return CERVICAL_CANCER_SURVEY_IDS;
    },
    CVD_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS: function() {
        return CVD_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS;
    },
    CVD_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS: function() {
        return CVD_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS;
    },
    CVD_SURVEY_GROUP_KEY: function() {
        return CVD_SURVEY_GROUP_KEY;
    },
    CVD_SURVEY_IDS: function() {
        return CVD_SURVEY_IDS;
    },
    FORM_NAME_BY_SURVEY_GROUP_KEY: function() {
        return FORM_NAME_BY_SURVEY_GROUP_KEY;
    },
    FORM_SURVEY_IDS: function() {
        return FORM_SURVEY_IDS;
    },
    PRIMARY_SCREENING_PENDING_REFERRALS_REPORT_COLUMN_TEMPLATE: function() {
        return PRIMARY_SCREENING_PENDING_REFERRALS_REPORT_COLUMN_TEMPLATE;
    },
    PRIMARY_SCREENING_REPORT_COLUMN_TEMPLATE: function() {
        return PRIMARY_SCREENING_REPORT_COLUMN_TEMPLATE;
    },
    REFERRAL_NAME_BY_SURVEY_GROUP_KEY: function() {
        return REFERRAL_NAME_BY_SURVEY_GROUP_KEY;
    },
    REFERRAL_SURVEY_IDS: function() {
        return REFERRAL_SURVEY_IDS;
    },
    getSurveyResultDataElement: function() {
        return getSurveyResultDataElement;
    }
});
const CVD_PRIMARY_FORM_SURVEY_ID = 'program-fijincdprimaryscreening-fijicvdprimaryscreen2';
const CVD_PRIMARY_REFERRAL_SURVEY_ID = 'program-fijincdprimaryscreening-fijicvdprimaryscreenref';
const BREAST_CANCER_FORM_SURVEY_ID = 'program-fijincdprimaryscreening-fijibreastprimaryscreen';
const BREAST_CANCER_REFERRAL_SURVEY_ID = 'program-fijincdprimaryscreening-fijibreastscreenref';
const CERVICAL_CANCER_FORM_SURVEY_ID = 'program-fijincdprimaryscreening-fijicervicalprimaryscreen';
const CERVICAL_CANCER_REFERRAL_SURVEY_ID = 'program-fijincdprimaryscreening-fijicervicalscreenref';
const PRIMARY_SCREENING_REPORT_COLUMN_TEMPLATE = [
    {
        title: 'First name',
        accessor: (data)=>data.firstName
    },
    {
        title: 'Last name',
        accessor: (data)=>data.lastName
    },
    {
        title: 'Patient ID',
        accessor: (data)=>data.displayId
    },
    {
        title: 'Age',
        accessor: (data)=>data.age
    },
    {
        title: 'Gender',
        accessor: (data)=>data.gender
    },
    {
        title: 'Ethnicity',
        accessor: (data)=>data.ethnicity
    },
    {
        title: 'Contact number',
        accessor: (data)=>data.contactNumber
    },
    {
        title: 'Subdivison',
        accessor: (data)=>data.village
    },
    {
        title: 'Medical area',
        accessor: (data)=>data.medicalArea
    },
    {
        title: 'Nursing zone',
        accessor: (data)=>data.nursingZone
    },
    {
        title: 'Screening completed',
        accessor: (data)=>data.screeningCompleted
    },
    {
        title: 'Date of screening',
        accessor: (data)=>data.dateOfScreening
    },
    {
        title: 'Screening location',
        accessor: (data)=>data.screeningLocation
    },
    {
        title: 'Screening health facility',
        accessor: (data)=>data.screeningHealthFacility
    },
    {
        title: 'Screening CSO',
        accessor: (data)=>data.nameOfCso
    },
    {
        title: 'Screening eligibility',
        accessor: (data)=>data.screeningEligibility
    },
    {
        title: 'CVD risk level',
        accessor: (data)=>data.cvdRiskLevel
    },
    {
        title: 'Breast cancer risk level',
        accessor: (data)=>data.breastCancerRiskLevel
    },
    {
        title: 'Referral created',
        accessor: (data)=>data.referralCreated
    },
    {
        title: 'Date of referral',
        accessor: (data)=>data.dateOfReferral
    },
    {
        title: 'Referred to health facility',
        accessor: (data)=>data.referredToHealthFacility
    },
    {
        title: 'Expected attendance date',
        accessor: (data)=>data.expectedAttendanceDate
    },
    {
        title: 'Referral status',
        accessor: (data)=>data.referralStatus
    }
];
const PRIMARY_SCREENING_PENDING_REFERRALS_REPORT_COLUMN_TEMPLATE = [
    {
        title: 'First name',
        accessor: (data)=>data.firstName
    },
    {
        title: 'Last name',
        accessor: (data)=>data.lastName
    },
    {
        title: 'Patient ID',
        accessor: (data)=>data.displayId
    },
    {
        title: 'Age',
        accessor: (data)=>data.age
    },
    {
        title: 'Gender',
        accessor: (data)=>data.gender
    },
    {
        title: 'Ethnicity',
        accessor: (data)=>data.ethnicity
    },
    {
        title: 'Contact number',
        accessor: (data)=>data.contactNumber
    },
    {
        title: 'Subdivison',
        accessor: (data)=>data.village
    },
    {
        title: 'Medical area',
        accessor: (data)=>data.medicalArea
    },
    {
        title: 'Nursing zone',
        accessor: (data)=>data.nursingZone
    },
    {
        title: 'Referral created',
        accessor: (data)=>data.referralCreated
    },
    {
        title: 'Referring health facility',
        accessor: (data)=>data.referringHealthFacility
    },
    {
        title: 'Referring CSO',
        accessor: (data)=>data.referringCso
    },
    {
        title: 'Date of referral',
        accessor: (data)=>data.dateOfReferral
    },
    {
        title: 'Expected attendance date',
        accessor: (data)=>data.expectedAttendanceDate
    },
    {
        title: 'Reason for referral',
        accessor: (data)=>data.reasonForReferral
    },
    {
        title: 'Date of screening',
        accessor: (data)=>data.dateOfScreening
    },
    {
        title: 'Screening location',
        accessor: (data)=>data.screeningLocation
    },
    {
        title: 'Screening health facility',
        accessor: (data)=>data.screeningHealthFacility
    },
    {
        title: 'Screening CSO',
        accessor: (data)=>data.nameOfCso
    },
    {
        title: 'CVD risk level',
        accessor: (data)=>data.cvdRiskLevel
    },
    {
        title: 'Breast cancer risk level',
        accessor: (data)=>data.breastCancerRiskLevel
    }
];
const CVD_SURVEY_IDS = [
    CVD_PRIMARY_FORM_SURVEY_ID,
    CVD_PRIMARY_REFERRAL_SURVEY_ID
];
const BREAST_CANCER_SURVEY_IDS = [
    BREAST_CANCER_FORM_SURVEY_ID,
    BREAST_CANCER_REFERRAL_SURVEY_ID
];
const CERVICAL_CANCER_SURVEY_IDS = [
    CERVICAL_CANCER_FORM_SURVEY_ID,
    CERVICAL_CANCER_REFERRAL_SURVEY_ID
];
const CVD_SURVEY_GROUP_KEY = 'CVD';
const BREAST_CANCER_SURVEY_GROUP_KEY = 'Breast_Cancer';
const CERVICAL_CANCER_SURVEY_GROUP_KEY = 'Cervical';
const ALL_SURVEY_IDS = [
    CVD_PRIMARY_FORM_SURVEY_ID,
    CVD_PRIMARY_REFERRAL_SURVEY_ID,
    BREAST_CANCER_FORM_SURVEY_ID,
    BREAST_CANCER_REFERRAL_SURVEY_ID,
    CERVICAL_CANCER_FORM_SURVEY_ID,
    CERVICAL_CANCER_REFERRAL_SURVEY_ID
];
const FORM_SURVEY_IDS = [
    CVD_PRIMARY_FORM_SURVEY_ID,
    BREAST_CANCER_FORM_SURVEY_ID,
    CERVICAL_CANCER_FORM_SURVEY_ID
];
const REFERRAL_SURVEY_IDS = [
    CVD_PRIMARY_REFERRAL_SURVEY_ID,
    BREAST_CANCER_REFERRAL_SURVEY_ID,
    CERVICAL_CANCER_REFERRAL_SURVEY_ID
];
const FORM_NAME_BY_SURVEY_GROUP_KEY = {
    [CVD_SURVEY_GROUP_KEY]: 'CVD Primary Screening',
    [BREAST_CANCER_SURVEY_GROUP_KEY]: 'Breast Cancer Primary Screening',
    [CERVICAL_CANCER_SURVEY_GROUP_KEY]: 'Cervical Cancer Primary Screening'
};
const REFERRAL_NAME_BY_SURVEY_GROUP_KEY = {
    [CVD_SURVEY_GROUP_KEY]: 'CVD Primary Screening Referral',
    [BREAST_CANCER_SURVEY_GROUP_KEY]: 'Breast Cancer Primary Screening Referral',
    [CERVICAL_CANCER_SURVEY_GROUP_KEY]: 'Cervical Cancer Primary Screening Referral'
};
const getSurveyResultDataElement = (surveyId)=>`${surveyId}|$result`;
const CVD_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS = {
    dateOfScreening: 'pde-FijCVD002',
    screeningLocation: 'pde-FijCVD004',
    screeningHealthFacility: 'pde-FijCVD007',
    nameOfCso: 'pde-FijCVD010',
    screeningEligibility: 'pde-FijCVD021',
    cvdRiskLevel: getSurveyResultDataElement(CVD_PRIMARY_FORM_SURVEY_ID)
};
const CVD_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS = {
    dateOfReferral: 'pde-FijCVDRef4',
    referredToHealthFacility: 'pde-FijCVDRef6',
    expectedAttendanceDate: 'pde-FijCVDRef7',
    referringCso: 'pde-FijCVDRef2a',
    reasonForReferral: 'pde-FijCVDRef11',
    referringHealthFacility: 'pde-FijCVDRef2'
};
const BREAST_CANCER_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS = {
    dateOfScreening: 'pde-FijBS02',
    screeningLocation: 'pde-FijBS04',
    screeningHealthFacility: 'pde-FijBS07',
    nameOfCso: 'pde-FijBS10',
    screeningEligibility: 'pde-FijBS14',
    breastCancerRiskLevel: getSurveyResultDataElement(BREAST_CANCER_FORM_SURVEY_ID)
};
const BREAST_CANCER_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS = {
    dateOfReferral: 'pde-FijBCRef04',
    referredToHealthFacility: 'pde-FijBCRef06',
    expectedAttendanceDate: 'pde-FijBCRef07',
    referringCso: 'pde-FijBCRef2a',
    reasonForReferral: 'pde-FijBCRef10',
    referringHealthFacility: 'pde-FijBCRef02'
};
const CERVICAL_CANCER_PRIMARY_SCREENING_FORM_DATA_ELEMENT_IDS = {
    dateOfScreening: 'pde-FijCC02',
    screeningLocation: 'pde-FijCC04',
    screeningHealthFacility: 'pde-FijCC07',
    nameOfCso: 'pde-FijCC10',
    screeningEligibility: 'pde-FijCC16'
};
const CERVICAL_CANCER_PRIMARY_SCREENING_REFERRAL_DATA_ELEMENT_IDS = {
    dateOfReferral: 'pde-FijCCRef04',
    referredToHealthFacility: 'pde-FijCCRef06',
    expectedAttendanceDate: 'pde-FijCCRef07',
    referringCso: 'pde-FijCCRef2a',
    reasonForReferral: 'pde-FijCCRef10',
    referringHealthFacility: 'pde-FijCCRef02'
};

//# sourceMappingURL=constants.js.map