"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const { DatabaseError } = require('sequelize');
const _default = {
    up: async (query)=>{
        // This migration can fail if enum_notes_record_type already includes LabRequest
        // so if it fails we can just ignore it
        try {
            await query.sequelize.query("ALTER TYPE enum_notes_record_type ADD VALUE 'LabRequest'");
        } catch (e) {
            if (e instanceof DatabaseError) {
                if (e.message.match(`already exists`)) {
                    return;
                }
            }
            // it failed for a different reason - rethrow
            throw e;
        }
    },
    down: async ()=>{
    // no down migration - it's unsafe to delete enums
    }
};

//# sourceMappingURL=033_addLabRequestNoteRecordType.js.map