import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class Invoice extends Model {
    id: string;
    displayId: string;
    date: string;
    status: string;
    patientPaymentStatus: string;
    insurerPaymentStatus: string;
    encounterId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getFullReferenceAssociations(): (string | {
        model: typeof import("./InvoiceDiscount").InvoiceDiscount;
        as: string;
        include: {
            model: typeof import("./User").User;
            as: string;
            attributes: string[];
        }[];
    } | {
        model: typeof import("./InvoiceInsurer").InvoiceInsurer;
        as: string;
        include: {
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
        }[];
    } | {
        model: typeof import("./InvoiceItem").InvoiceItem;
        as: string;
        include: ({
            model: typeof import("./InvoiceProduct").InvoiceProduct;
            as: string;
            include: ({
                model: typeof import("./ReferenceData").ReferenceData;
                as: string;
                attributes: string[];
            } | {
                model: typeof import("./LabTestType").LabTestType;
                as: string;
                attributes: string[];
            })[];
            attributes?: undefined;
        } | {
            model: typeof import("./User").User;
            as: string;
            attributes: string[];
            include?: undefined;
        } | {
            model: typeof import("./InvoiceItemDiscount").InvoiceItemDiscount;
            as: string;
            include?: undefined;
            attributes?: undefined;
        })[];
    } | {
        model: typeof import("./InvoicePayment").InvoicePayment;
        as: string;
        include: ({
            model: typeof import("./User").User;
            as: string;
            include?: undefined;
        } | {
            model: typeof import("./InvoicePatientPayment").InvoicePatientPayment;
            as: string;
            include: {
                model: typeof import("./ReferenceData").ReferenceData;
                as: string;
            }[];
        } | {
            model: typeof import("./InvoiceInsurerPayment").InvoiceInsurerPayment;
            as: string;
            include: {
                model: typeof import("./ReferenceData").ReferenceData;
                as: string;
            }[];
        })[];
    })[];
}
//# sourceMappingURL=Invoice.d.ts.map