"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTest", {
    enumerable: true,
    get: function() {
        return LabTest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _Model = require("./Model");
const _model = require("../types/model");
const _dateTime = require("@tamanu/utils/dateTime");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
let LabTest = class LabTest extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _model.dateType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateString
            }),
            result: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: ''
            },
            laboratoryOfficer: {
                type: _sequelize.DataTypes.STRING
            },
            verification: {
                type: _sequelize.DataTypes.STRING
            },
            completedDate: (0, _model.dateTimeType)('completedDate')
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'categoryId',
            as: 'category'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'labTestMethodId',
            as: 'labTestMethod'
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'labTestTypeId',
            as: 'labTestType'
        });
    }
    static getListReferenceAssociations() {
        return [
            'category',
            'labTestType',
            'labTestMethod'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable, sessionConfig) {
        if (sessionConfig.syncAllLabRequests) {
            return ''; // include all lab tests
        }
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'lab_requests',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupSelect)(this, {
                isLabRequestValue: 'TRUE'
            }),
            joins: (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupJoins)(this, [
                'lab_requests',
                'encounters'
            ])
        };
    }
};

//# sourceMappingURL=LabTest.js.map