import { type InitOptions } from 'sequelize';
import { FhirResource } from './Resource';
import type { Models } from '../../types/model';
export declare class FhirServiceRequest extends FhirResource {
    identifier?: Record<string, any>;
    status: string;
    intent: string;
    category?: Record<string, any>;
    priority?: string;
    code?: Record<string, any>;
    orderDetail?: Record<string, any>;
    subject: Record<string, any>;
    encounter?: Record<string, any>;
    occurrenceDateTime?: string;
    requester?: Record<string, any>;
    locationCode?: Record<string, any>;
    note?: Record<string, any>;
    specimen?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    updateIsLive(): Promise<void>;
    shouldForceRematerialise(): Promise<boolean>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string): Promise<{
        include: {
            model: typeof import("..").Note;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
    } | {
        include: {
            model: typeof import("..").Encounter;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
    } | {
        include: {
            model: typeof import("..").Encounter;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").Patient;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
    } | {
        where: {
            id: string;
        };
        include?: undefined;
    } | {
        include: {
            model: typeof import("..").ImagingRequestArea;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Encounter;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").Location;
                as: string;
                required: boolean;
                include: {
                    model: typeof import("..").Facility;
                    as: string;
                    required: boolean;
                    where: {
                        id: string;
                    };
                }[];
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Encounter;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").Location;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LocationGroup;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").ImagingRequestArea;
            required: boolean;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").ImagingRequestArea;
            required: boolean;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
                required: boolean;
                include: {
                    model: typeof import("..").ImagingAreaExternalCode;
                    as: string;
                    required: boolean;
                    where: {
                        id: string;
                    };
                }[];
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").User;
            as: string;
            required: boolean;
        }[];
        where: {
            [x: symbol]: ({
                '$requestedBy.id$': string;
                '$completedBy.id$'?: undefined;
            } | {
                '$completedBy.id$': string;
                '$requestedBy.id$'?: undefined;
            })[];
            id?: undefined;
        };
    } | {
        include: {
            model: typeof import("..").LabTest;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LabTest;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").LabTestType;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LabTestPanelRequest;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").LabTestPanelRequest;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").LabTestPanel;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").User;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | null>;
    static searchParameters(): {
        identifier: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        category: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        intent: {
            type: string;
            path: string[][];
        };
        occurrence: {
            type: string;
            path: string[][];
        };
        priority: {
            type: string;
            path: string[][];
        };
        status: {
            type: string;
            path: string[][];
        };
        subject: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
        encounter: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
        requester: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
        specimen: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
    };
}
//# sourceMappingURL=FhirServiceRequest.d.ts.map