"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "nzEthnicity", {
    enumerable: true,
    get: function() {
        return nzEthnicity;
    }
});
const _fhirTypes = require("@tamanu/shared/services/fhirTypes");
const _withConfig = require("@tamanu/shared/utils/withConfig");
function getEthnicity(ethnicityId) {
    switch(ethnicityId){
        case 'ethnicity-ITaukei':
            return {
                code: '36111',
                display: 'Fijian/iTaukei'
            };
        case 'ethnicity-FID':
            return {
                code: '43112',
                display: 'Fijian Indian'
            };
        case null:
        case undefined:
            return {
                code: '99999',
                display: 'Not Stated'
            };
        default:
            return {
                code: '61199',
                display: 'Other Ethnicity nec'
            };
    }
}
const nzEthnicity = (0, _withConfig.withConfig)((patient, config)=>{
    if (!config.integrations.fhir.extensions.Patient.newZealandEthnicity) return [];
    const { code, display } = getEthnicity(patient?.additionalData?.[0]?.ethnicityId);
    return [
        new _fhirTypes.FhirExtension({
            url: 'http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity',
            valueCodeableConcept: new _fhirTypes.FhirCodeableConcept({
                coding: [
                    new _fhirTypes.FhirCoding({
                        system: config.hl7.dataDictionaries.ethnicityId,
                        code,
                        display
                    })
                ]
            })
        })
    ];
});

//# sourceMappingURL=extensions.js.map