"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "RateLimitedError", {
    enumerable: true,
    get: function() {
        return RateLimitedError;
    }
});
const _BaseError = require("../BaseError");
const _constants = require("../constants");
let RateLimitedError = class RateLimitedError extends _BaseError.BaseError {
    constructor(retryAfterSec, detail){
        super(_constants.ERROR_TYPE.RATE_LIMITED, 'Rate limited', 429, detail);
        this.extraData = {
            'retry-after': retryAfterSec
        };
    }
};

//# sourceMappingURL=RateLimitedError.js.map