"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirTiming", {
    enumerable: true,
    get: function() {
        return FhirTiming;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const PERIOD_UNITS = [
    's',
    'min',
    'h',
    'd',
    'wk',
    'mo',
    'a'
]; // https://hl7.org/fhir/R4B/valueset-units-of-time.html
const TIME_OF_DAY_REGEX = /^([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\.[0-9]+)?$/; // https://hl7.org/fhir/R4B/datatypes.html#time
let FhirTiming = class FhirTiming extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            repeat: _yup.object({
                frequency: _yup.number().nullable().default(null),
                period: _yup.number().nullable().default(null),
                periodUnit: _yup.string().oneOf([
                    undefined,
                    null,
                    ...PERIOD_UNITS
                ]).nullable().default(null),
                timeOfDay: _yup.array().of(_yup.string()).test('is-valid-time-of-day', 'Invalid time of day', (value)=>{
                    if (!value) return true;
                    return value.every((time)=>TIME_OF_DAY_REGEX.test(time));
                }).nullable().default(null)
            }).nullable().default(null)
        }).noUnknown();
    }
    static fake() {
        return new this({
            repeat: {
                frequency: (0, _lodash.random)(1, 10),
                period: (0, _lodash.random)(1, 10),
                periodUnit: PERIOD_UNITS[(0, _lodash.random)(0, PERIOD_UNITS.length - 1)],
                timeOfDay: null
            }
        });
    }
};

//# sourceMappingURL=timing.js.map