import { z } from 'zod';
export declare const PortalSurveyAssignmentsSchema: z.ZodObject<{
    id: z.ZodString;
    patient: z.ZodObject<{
        id: z.ZodString;
        displayId: z.ZodString;
        firstName: z.ZodString;
        middleName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        lastName: z.ZodString;
        dateOfBirth: z.ZodString;
        sex: z.ZodEnum<{
            MALE: string;
            FEMALE: string;
            OTHER: string;
        }>;
        village: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
    }, z.core.$strip>;
    assignedBy: z.ZodObject<{
        id: z.ZodString;
        displayName: z.ZodString;
    }, z.core.$strip>;
    assignedAt: z.ZodString;
    survey: z.ZodObject<{
        id: z.ZodString;
        code: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        name: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        surveyType: z.ZodOptional<z.ZodNullable<z.ZodEnum<{
            PROGRAMS: string;
            REFERRAL: string;
            OBSOLETE: string;
            VITALS: string;
            SIMPLE_CHART: string;
            COMPLEX_CHART: string;
            COMPLEX_CHART_CORE: string;
        }>>>;
        program: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            code: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
    }, z.core.$strip>;
    status: z.ZodEnum<{
        OUTSTANDING: string;
        COMPLETED: string;
        CANCELLED: string;
    }>;
}, z.core.$strip>;
export type PortalSurveyAssignments = z.infer<typeof PortalSurveyAssignmentsSchema>;
//# sourceMappingURL=portalSurveyAssignments.schema.d.ts.map