"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DEFAULT_BATCH_SIZE: function() {
        return DEFAULT_BATCH_SIZE;
    },
    runFunctionInBatches: function() {
        return runFunctionInBatches;
    }
});
const DEFAULT_BATCH_SIZE = 10000;
async function runFunctionInBatches(arrayToBeBatched, functionToRun, batchSize = DEFAULT_BATCH_SIZE) {
    if (batchSize <= 0) {
        throw new Error('batchSize must be a positive number.');
    }
    const results = [];
    for(let i = 0; i < arrayToBeBatched.length; i += batchSize){
        const batch = arrayToBeBatched.slice(i, i + batchSize);
        const chunkedResult = await functionToRun(batch);
        results.push(...chunkedResult);
    }
    return results;
}

//# sourceMappingURL=runFunctionInBatches.js.map