"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "addHooks", {
    enumerable: true,
    get: function() {
        return addHooks;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _CreateReferralNotification = require("@tamanu/shared/tasks/CreateReferralNotification");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function addHooks(store) {
    if (_config.default.notifications?.referralCreated) {
        store.models.Referral.addHook('afterCreate', 'create referral notification hook', (referral)=>{
            (0, _CreateReferralNotification.createReferralNotification)(referral, store.models);
        });
    }
}

//# sourceMappingURL=hooks.js.map