import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class PharmacyOrder extends Model {
    id: string;
    orderingClinicianId: string;
    encounterId: string;
    comments?: string;
    isDischargePrescription: boolean;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=PharmacyOrder.d.ts.map