import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { dateType } from '../types/model';
export class UserLeave extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            startDate: dateType('startDate', {
                allowNull: false
            }),
            endDate: dateType('endDate', {
                allowNull: false
            })
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
}

//# sourceMappingURL=UserLeave.js.map