"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ERROR_TYPE: function() {
        return ERROR_TYPE;
    },
    IANA_TYPES: function() {
        return IANA_TYPES;
    },
    WELL_KNOWN_PROBLEM_KEYS: function() {
        return WELL_KNOWN_PROBLEM_KEYS;
    },
    isKnownErrorType: function() {
        return isKnownErrorType;
    }
});
const ERROR_TYPE = {
    AUTH: 'auth',
    AUTH_CREDENTIAL_INVALID: 'auth-credential-invalid',
    AUTH_CREDENTIAL_MISSING: 'auth-credential-missing',
    AUTH_PERMISSION_REQUIRED: 'auth-permission-required',
    AUTH_QUOTA_EXCEEDED: 'auth-quota-exceeded',
    AUTH_TOKEN_INVALID: 'auth-token-invalid',
    CLIENT_INCOMPATIBLE: 'client-incompatible',
    DATABASE: 'database',
    EDIT_CONFLICT: 'conflict',
    FORBIDDEN: 'forbidden',
    NOT_FOUND: 'not-found',
    RATE_LIMITED: 'rate-limited',
    REMOTE: 'remote',
    REMOTE_INCOMPATIBLE: 'remote-incompatible',
    REMOTE_UNREACHABLE: 'remote-unreachable',
    STORAGE_INSUFFICIENT: 'storage-insufficient',
    UNKNOWN: 'unknown',
    UNIMPLEMENTED: 'unimplemented',
    VALIDATION: 'validation',
    VALIDATION_CONSTRAINT: 'validation-constraint',
    VALIDATION_DATABASE: 'validation-database',
    VALIDATION_DUPLICATE: 'validation-duplicate',
    VALIDATION_OPERATION: 'validation-operation',
    VALIDATION_PARAMETER: 'validation-parameter',
    VALIDATION_RELATION: 'validation-relation'
};
const IANA_TYPES = [];
function isKnownErrorType(type) {
    return Object.values(ERROR_TYPE).includes(type);
}
const WELL_KNOWN_PROBLEM_KEYS = [
    'type',
    'title',
    'status',
    'detail',
    'instance'
];

//# sourceMappingURL=constants.js.map