"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceProduct", {
    enumerable: true,
    get: function() {
        return InvoiceProduct;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("../Model");
let InvoiceProduct = class InvoiceProduct extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            discountable: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false
            },
            category: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            sourceRecordType: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            sourceRecordId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'sourceRecordId',
            as: 'sourceRefDataRecord'
        });
        this.belongsTo(models.LabTestPanel, {
            foreignKey: 'sourceRecordId',
            as: 'sourceLabTestPanelRecord'
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'sourceRecordId',
            as: 'sourceLabTestTypeRecord'
        });
        // Has many in the context of importing and storing data
        this.hasMany(models.InvoicePriceListItem, {
            foreignKey: 'invoiceProductId',
            as: 'invoicePriceListItems'
        });
        // Has one in the context of fetching data from the api
        this.hasOne(models.InvoicePriceListItem, {
            foreignKey: 'invoiceProductId',
            as: 'invoicePriceListItem'
        });
        this.hasMany(models.InvoiceInsurancePlanItem, {
            foreignKey: 'invoiceProductId',
            as: 'invoiceInsurancePlanItems'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        return [
            'invoicePriceListItems'
        ];
    }
};

//# sourceMappingURL=InvoiceProduct.js.map