import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from '../Model';
import { buildEncounterLinkedSyncFilter } from '../../sync/buildEncounterLinkedSyncFilter';
import { dateType } from '../../types/model';
import { buildEncounterLinkedLookupJoins, buildEncounterLinkedLookupSelect } from '../../sync/buildEncounterLinkedLookupFilter';
export class InvoicePayment extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: dateType('date', {
                allowNull: false
            }),
            receiptNumber: {
                type: DataTypes.STRING,
                allowNull: false
            },
            amount: {
                type: DataTypes.DECIMAL,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Invoice, {
            foreignKey: 'invoiceId',
            as: 'invoice'
        });
        this.hasOne(models.InvoicePatientPayment, {
            foreignKey: 'invoicePaymentId',
            as: 'patientPayment'
        });
        this.hasOne(models.InvoiceInsurerPayment, {
            foreignKey: 'invoicePaymentId',
            as: 'insurerPayment'
        });
        this.belongsTo(models.User, {
            foreignKey: 'updatedByUserId',
            as: 'updatedByUser'
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return buildEncounterLinkedSyncFilter([
            this.tableName,
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildEncounterLinkedLookupSelect(this),
            joins: buildEncounterLinkedLookupJoins(this, [
                'invoices',
                'encounters'
            ])
        };
    }
    static getListReferenceAssociations(models) {
        return [
            {
                model: models.User,
                as: 'updatedByUser'
            },
            {
                model: models.InvoicePatientPayment,
                as: 'patientPayment',
                include: models.InvoicePatientPayment.getListReferenceAssociations(models)
            },
            {
                model: models.InvoiceInsurerPayment,
                as: 'insurerPayment',
                include: models.InvoiceInsurerPayment.getListReferenceAssociations(models)
            }
        ];
    }
}

//# sourceMappingURL=InvoicePayment.js.map