import { FhirResource } from './Resource';
import type { InitOptions, Models } from '../../types/model';
export declare class FhirEncounter extends FhirResource {
    status: string;
    class?: Record<string, any>;
    subject?: Record<string, any>;
    actualPeriod?: Record<string, any>;
    location?: Record<string, any>;
    serviceProvider?: Record<string, any>;
    static initModel(options: InitOptions, models: Models): void;
    static CAN_DO: Set<string>;
    updateMaterialisation(): Promise<void>;
    static queryToFindUpstreamIdsFromTable(upstreamTable: string, table: string, id: string, deletedRow?: null): Promise<{
        where: {
            id: string;
        };
        include?: undefined;
    } | {
        include: {
            model: typeof import("..").Discharge;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Patient;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Location;
            as: string;
            required: boolean;
            where: {
                id: string;
            };
        }[];
        where?: undefined;
    } | {
        include: {
            model: typeof import("..").Location;
            as: string;
            required: boolean;
            include: {
                model: typeof import("..").LocationGroup;
                as: string;
                required: boolean;
                where: {
                    id: string;
                };
            }[];
        }[];
        where?: undefined;
    } | null>;
    static queryToFilterUpstream(upstreamTable: string): Promise<{
        where: {
            encounterType: {
                [x: symbol]: string;
            };
        };
    } | null>;
    asFhir(): Record<string, any>;
    static searchParameters(): {
        class: {
            type: string;
            path: string[][];
            tokenType: string;
        };
        'date-start': {
            type: string;
            path: string[][];
            datePrecision: string;
        };
        'end-date': {
            type: string;
            path: string[][];
            datePrecision: string;
        };
        status: {
            type: string;
            path: string[][];
        };
        subject: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
        serviceProvider: {
            type: string;
            path: string[][];
            referenceTypes: string[];
        };
    };
}
//# sourceMappingURL=FhirEncounter.d.ts.map