export const extractChangelogFromSnapshotRecords = (snapshotRecordsWithChangelog)=>{
    const changelogRecords = [];
    const processedRecords = snapshotRecordsWithChangelog.reduce((acc, row)=>{
        if (row.changelogRecords) {
            changelogRecords.push(...row.changelogRecords);
            delete row.changelogRecords;
        }
        acc.push(row);
        return acc;
    }, []);
    return {
        snapshotRecords: processedRecords,
        changelogRecords
    };
};

//# sourceMappingURL=extractChangelogFromSnapshotRecords.js.map