import { SettingPath } from '../types';
import { Models } from './readers/SettingsDBReader';
export declare const KEYS_EXPOSED_TO_FRONT_END: readonly ["audit", "appointments", "ageDisplayFormat", "customisations", "features", "fields", "imagingCancellationReasons", "imagingPriorities", "insurer", "customisations", "locationAssignments", "printMeasures", "invoice", "labsCancellationReasons", "templates", "layouts", "security.mobile", "triageCategories", "upcomingVaccinations", "vaccinations", "vitalEditReasons", "medications", "sync", "mobileSync"];
export declare const KEYS_EXPOSED_TO_PATIENT_PORTAL: readonly ["features", "fileChooserMbSizeLimit"];
export declare class ReadSettings<Path = SettingPath> {
    models: Models;
    facilityId?: string;
    constructor(models: Models, facilityId?: string);
    get<T extends string | number | object>(key: Path): Promise<T>;
    getFrontEndSettings(): Promise<Pick<{
        [x: string]: string | number | object;
    }, "appointments" | "sync" | "vaccinations" | "templates" | "audit" | "ageDisplayFormat" | "locationAssignments" | "features" | "customisations" | "fields" | "invoice" | "imagingCancellationReasons" | "imagingPriorities" | "labsCancellationReasons" | "printMeasures" | "layouts" | "triageCategories" | "upcomingVaccinations" | "vitalEditReasons" | "medications" | "insurer" | "security.mobile" | "mobileSync">>;
    getPatientPortalSettings(): Promise<Pick<{
        [x: string]: string | number | object;
    }, "features" | "fileChooserMbSizeLimit">>;
    getAll(): Promise<{
        [x: string]: string | number | object;
    }>;
}
