"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "invoicePriceListItemLoaderFactory", {
    enumerable: true,
    get: function() {
        return invoicePriceListItemLoaderFactory;
    }
});
const _ProductMatrixByCodeLoaderFactory = require("./ProductMatrixByCodeLoaderFactory");
function invoicePriceListItemLoaderFactory() {
    return (0, _ProductMatrixByCodeLoaderFactory.productMatrixByCodeLoaderFactory)({
        parentModel: 'InvoicePriceList',
        itemModel: 'InvoicePriceListItem',
        parentIdField: 'invoicePriceListId',
        valueField: 'price',
        messages: {
            duplicateCode: (code)=>`duplicate price list code: ${code}`,
            missingParentByCode: (code)=>`InvoicePriceList with code '${code}' does not exist`,
            couldNotFindParentId: (code)=>`Could not find InvoicePriceList ID for code '${code}'`,
            invalidValue: (raw, code, invoiceProductId)=>`Invalid price value '${raw}' for priceList '${code}' and invoiceProductId '${invoiceProductId}'`
        }
    });
}

//# sourceMappingURL=invoicePriceListItemLoaderFactory.js.map