"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`CREATE TYPE fhir.immunization_performer AS (
    function                    fhir.codeable_concept,
    actor                       fhir.reference
  )`);
    await query.sequelize.query(`CREATE TYPE fhir.immunization_protocol_applied AS (
    series                      text,
    authority                   fhir.reference,
    target_disease              fhir.codeable_concept[],
    dose_number_positive_int    integer,
    dose_number_string          text,
    series_doses_positive_int   integer,
    series_doses_string         text
  )`);
    await query.sequelize.query(`CREATE TYPE fhir.extension AS (
    url                         text,
    value_codeable_concept      fhir.codeable_concept
  )`);
}
async function down(query) {
    await query.sequelize.query('DROP TYPE fhir.immunization_protocol_applied');
    await query.sequelize.query('DROP TYPE fhir.immunization_performer');
    await query.sequelize.query('DROP TYPE fhir.extension');
}

//# sourceMappingURL=148_moreFhirTypes.js.map