"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE MATERIALIZED VIEW materialized_upcoming_vaccinations AS
    SELECT *
    FROM upcoming_vaccinations
  `);
    // There is a requirement of a unique index on the materialized view
    // in order to refresh concurrently
    await query.sequelize.query(`
    CREATE UNIQUE INDEX materialized_upcoming_vaccinations_unique_index
    ON materialized_upcoming_vaccinations (patient_id, scheduled_vaccine_id);
  `);
}
async function down(query) {
    await query.sequelize.query('DROP MATERIALIZED VIEW materialized_upcoming_vaccinations;');
}

//# sourceMappingURL=1715825323638-addMaterializedUpcomingVaccinations.js.map