"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    KEYS_EXPOSED_TO_FRONT_END: function() {
        return KEYS_EXPOSED_TO_FRONT_END;
    },
    KEYS_EXPOSED_TO_PATIENT_PORTAL: function() {
        return KEYS_EXPOSED_TO_PATIENT_PORTAL;
    },
    ReadSettings: function() {
        return ReadSettings;
    }
});
const _lodash = require("lodash");
const _ = require("..");
const _cache = require("../cache");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
const KEYS_EXPOSED_TO_FRONT_END = [
    'audit',
    'appointments',
    'ageDisplayFormat',
    'customisations',
    'features',
    'fields',
    'imagingCancellationReasons',
    'imagingPriorities',
    'insurer',
    'customisations',
    'locationAssignments',
    'printMeasures',
    'invoice',
    'labsCancellationReasons',
    'templates',
    'layouts',
    'security.mobile',
    'triageCategories',
    'upcomingVaccinations',
    'vaccinations',
    'vitalEditReasons',
    'medications',
    'sync',
    'mobileSync'
];
const KEYS_EXPOSED_TO_PATIENT_PORTAL = [
    'features',
    'fileChooserMbSizeLimit'
];
let ReadSettings = class ReadSettings {
    async get(key) {
        const settings = await this.getAll();
        return (0, _lodash.get)(settings, key);
    }
    // This is what is called on tamanu-web login. This gets only settings relevant to
    // the frontend so only what is needed is sent. No sensitive data is sent.
    async getFrontEndSettings() {
        const allSettings = await this.getAll();
        return (0, _lodash.pick)(allSettings, KEYS_EXPOSED_TO_FRONT_END);
    }
    async getPatientPortalSettings() {
        const allSettings = await this.getAll();
        return (0, _lodash.pick)(allSettings, KEYS_EXPOSED_TO_PATIENT_PORTAL);
    }
    async getAll() {
        let settings = _cache.settingsCache.getAllSettings(this.facilityId);
        if (!settings) {
            settings = await (0, _.buildSettings)(this.models, this.facilityId);
            _cache.settingsCache.setAllSettings(settings, this.facilityId);
        }
        return settings;
    }
    constructor(models, facilityId){
        _define_property(this, "models", void 0);
        _define_property(this, "facilityId", void 0);
        this.models = models;
        this.facilityId = facilityId;
    }
};

//# sourceMappingURL=ReadSettings.js.map